

<?php $__env->startSection('content'); ?>
<section id="number-tabs">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title"><?php echo $form['heading']; ?></h4>
                </div>
                <div class="card-content">
                    <div class="card-body">
                        <form method="POST" action="<?php echo $form['action']; ?>" class="number-tab-steps wizard-circle" enctype="multipart/form-data">
                            <input type="hidden" name="id" value="<?php echo e($data->id); ?>">
                            <?php echo csrf_field(); ?>
                            <input type="hidden" name="_method" value="<?php echo $form['method']; ?>">

                            <fieldset>
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="name">Product Name *</label>
                                            <input type="text" id="name" name="name" value="<?php echo e(old('name', $data->name)); ?>" class="form-control" required>
                                        </div>
                                    </div>

                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="category_id">Category *</label>
                                            <select name="category_id" class="form-control" required>
                                                <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $id => $label): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($id); ?>" <?php echo e(old('category_id', $data->category_id) == $id ? 'selected' : ''); ?>>
                                                        <?php echo e($label); ?>

                                                    </option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                            </fieldset>

                            <fieldset>
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="sub_category_id">Sub Category</label>
                                            <select name="sub_category_id" class="form-control">
                                                <?php $__currentLoopData = $subCategories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $id => $label): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($id); ?>" <?php echo e(old('sub_category_id', $data->sub_category_id) == $id ? 'selected' : ''); ?>>
                                                        <?php echo e($label); ?>

                                                    </option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>
                                    </div>

                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <label for="min_price">Min Price *</label>
                                            <input type="text" name="min_price" value="<?php echo e(old('min_price', $data->min_price)); ?>" class="form-control" required>
                                        </div>
                                    </div>

                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <label for="price">Price *</label>
                                            <input type="text" name="price" value="<?php echo e(old('price', $data->price)); ?>" class="form-control" required>
                                        </div>
                                    </div>
                                </div>
                            </fieldset>

                            <fieldset>
                                <div class="row">
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label for="icon">Product Icon</label>
                                            <input type="file" name="icon" class="form-control">
                                            <?php if($data->icon): ?>
                                                <img src="https://hometown.eagleeblaze.com/storage/app/public/<?php echo e($data->icon); ?>" alt="icon" width="80" class="mt-1">
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                    
                                     <div class="col-md-4">
                                        <div class="form-group">
                                            <label for="icon">Product Size Chart</label>
                                             <input type="file" name="size_chart" class="form-control">
                                            <?php if($data->size_chart): ?>
                                                <img src="https://hometown.eagleeblaze.com/storage/app/public/<?php echo e($data->size_chart); ?>" alt="icon" width="80" class="mt-1">
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                            </fieldset>
                            
                            <fieldset>
                            <div class="row">
                                <div class="col-md-12">
                                    <label for="colors">Colors</label>
                                    <div id="color-wrapper">
                                        <?php 
                                            $colors = $data->colors_data;

                                        ?>
                        
                                        <?php if(!empty($colors)): ?>
                                            <?php $__currentLoopData = $colors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $color): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <div class="row color-row mb-2">
                                                    <div class="col-md-5">
                                                        <input type="text" name="colors_data[<?php echo e($index); ?>][name]" value="<?php echo e($color->name); ?>" class="form-control" placeholder="Color Name (e.g. Red)">
                                                    </div>
                                                    <div class="col-md-5">
                                                        <input type="color" name="colors_data[<?php echo e($index); ?>][code]" value="<?php echo e($color->code); ?>" class="form-control">
                                                    </div>
                                                    <div class="col-md-2">
                                                        <button type="button" class="btn btn-danger remove-color">X</button>
                                                    </div>
                                                </div>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php endif; ?>
                                    </div>
                        
                                    <button type="button" id="add-color" class="btn btn-sm btn-primary mt-2">+ Add Color</button>
                                </div>
                            </div>
                        </fieldset>

                            <fieldset>
                                <div class="row">
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label for="size">Size</label>
                                            <input type="text" name="size" value="<?php echo e(old('size', $data->size)); ?>" class="form-control">
                                        </div>
                                    </div>

                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label for="material">Material</label>
                                             <textarea name="material" maxlength="65000" rows="5" id="material" class="form-control"><?php echo e(old('material', $data->material ?? '')); ?></textarea>
                                        </div>
                                    </div>

                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label for="weight">Weight</label>
                                            <input type="text" name="weight" value="<?php echo e(old('weight', $data->weight)); ?>" class="form-control">
                                        </div>
                                    </div>
                                </div>
                            </fieldset>
                            
                             <fieldset>
                                <div class="row">
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label for="size">Profit Share USA</label>
                                            <input type="text" name="profit_usa" value="<?php echo e(old('profit_usa', $data->profit_usa)); ?>" class="form-control">
                                        </div>
                                    </div>

                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label for="material">Profit Share International</label>
                                            <input type="text" name="profit_international" value="<?php echo e(old('profit_international', $data->profit_international)); ?>" class="form-control">
                                        </div>
                                    </div>
                                    
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label for="material">Platform</label>
                                            <input type="text" name="platform" value="<?php echo e(old('platform', $data->platform)); ?>" class="form-control">
                                        </div>
                                    </div>
                                </div>
                            </fieldset>
                            
                            <fieldset>
                                <div class="row">
                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label for="long_description">Content</label>
                                            <textarea name="description" maxlength="65000" rows="5" id="description" class="form-control editor-tinymce"><?php echo e(old('description', $data->description ?? '')); ?></textarea>
                                        </div>
                                    </div>
                                </div>
                            </fieldset>

                            <div class="col-md-12">
                                <button type="submit" class="btn btn-primary mr-1 mb-1 waves-effect waves-light">Save Changes</button>
                                <a href="<?php echo $form['cancel_url']; ?>" class="btn btn-danger mr-1 mb-1 waves-effect waves-light" style="color: white">Cancel</a>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<script>
    document.addEventListener("DOMContentLoaded", function() {
        let colorIndex = <?php echo e(!empty($colors) ? count($colors) : 0); ?>;

        document.getElementById("add-color").addEventListener("click", function() {
            let wrapper = document.getElementById("color-wrapper");
            let html = `
                <div class="row color-row mb-2">
                    <div class="col-md-5">
                        <input type="text" name="colors_data[${colorIndex}][name]" class="form-control" placeholder="Color Name (e.g. Red)">
                    </div>
                    <div class="col-md-5">
                        <input type="color" name="colors_data[${colorIndex}][code]" value="#000000" class="form-control">
                    </div>
                    <div class="col-md-2">
                        <button type="button" class="btn btn-danger remove-color">X</button>
                    </div>
                </div>
            `;
            wrapper.insertAdjacentHTML('beforeend', html);
            colorIndex++;
        });

        document.addEventListener("click", function(e) {
            if(e.target && e.target.classList.contains("remove-color")) {
                e.target.closest(".color-row").remove();
            }
        });
    });
</script>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('footer-js'); ?>

<?php $__env->stopPush(); ?>


<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/u559086311/domains/eagleeblaze.com/public_html/hometown/resources/views/admin/products/form.blade.php ENDPATH**/ ?>