<?php $__env->startSection('content'); ?>
    <section id="column-selectors">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">Testimonials</h4>
                        <span><a href="<?php echo e(route('admin.testimonial.create')); ?>" class="btn btn-primary"><i class="fa fa-plus"></i> Add New</a></span>

                    </div>
                    <div class="card-content">
                        <div class="card-body card-dashboard">
                            <div class="table-responsive">
                                <table class="table table-striped" id="datatable">
                                    <thead>
                                    <tr>
                                        <th>Name</th>
                                        <th>Created At</th>
                                        <th>Status</th>
                                        <th>Actions</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $result): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><?php echo $result->name; ?></td>
                                            <td><span style="display: none"><?php echo strtotime($result->created_at); ?></span><?php echo date('d/m/Y H:i:A', strtotime($result->created_at)); ?></td>
                                            <td><small><span class="badge badge-<?php echo $result->status == 'published' ? 'success' : 'danger'; ?>"><?php echo strtoupper($result->status); ?></span></small></td>
                                            <td>


                                                <a href="<?php echo route('admin.testimonial.edit', $result->id); ?>" class="btn btn-primary btn-sm waves-effect waves-light"><i class="feather icon-edit"></i></a>

                                                <button type="button" class="btn btn-danger btn-sm waves-effect waves-light" onclick="deleteConfirmation(<?php echo $result->id; ?>)"><i class="feather icon-trash"></i></button>

                                                <form action="<?php echo URL::route('admin.testimonial.destroy', $result->id); ?>" method="POST" id="deleteForm<?php echo $result->id; ?>">
                                                    <?php echo csrf_field(); ?>
                                                    <?php echo method_field('DELETE'); ?>
                                                </form>

                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('footer-js'); ?>
    <script>
        $('#datatable').DataTable({
            "order": [[1, "desc"]] // Sort by the fourth column (created_at) in descending order
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/u559086311/domains/eagleeblaze.com/public_html/hometown/resources/views/admin/testimonials/index.blade.php ENDPATH**/ ?>