

<?php $__env->startSection('content'); ?>
<section id="column-selectors">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title">Products</h4>
                    <span>
                        <a href="<?php echo e(route('admin.products.create')); ?>" class="btn btn-primary">
                            <i class="fa fa-plus"></i> Add New
                        </a>
                    </span>
                </div>
                <div class="card-content">
                    <div class="card-body card-dashboard">
                        <div class="table-responsive">
                            <table class="table table-striped" id="datatable">
                                <thead>
                                    <tr>
                                        <th>Name</th>
                                        <th>Category</th>
                                        <th>Min Price</th>
                                        <th>Price</th>
                                        <th>Created At</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><?php echo e($product->name); ?></td>
                                            <td><?php echo e(optional($product->category)->name ?? '-'); ?></td>
                                            <td><?php echo e($product->min_price); ?></td>
                                            <td><?php echo e($product->price); ?></td>
                                            <td>
                                                <span style="display: none"><?php echo e(strtotime($product->created_at)); ?></span>
                                                <?php echo e(date('d/m/Y H:i:A', strtotime($product->created_at))); ?>

                                            </td>
                                            <td>
                                                <div class="d-flex gap-2">
                                                    <a href="<?php echo e(route('admin.products.edit', $product->id)); ?>" class="btn btn-primary btn-sm waves-effect waves-light">
                                                        <i class="feather icon-edit"></i>
                                                    </a>
                                                    <button type="button" class="btn btn-danger btn-sm waves-effect waves-light" onclick="deleteConfirmation(<?php echo e($product->id); ?>)">
                                                        <i class="feather icon-trash"></i>
                                                    </button>
                                                    <form action="<?php echo e(route('admin.products.destroy', $product->id)); ?>" method="POST" id="deleteForm<?php echo e($product->id); ?>">
                                                        <?php echo csrf_field(); ?>
                                                        <?php echo method_field('DELETE'); ?>
                                                    </form>
                                                </div>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('footer-js'); ?>
<script>
    $('#datatable').DataTable({
        "order": [[5, "desc"]] // created_at column
    });

    function deleteConfirmation(id) {
        if (confirm('Are you sure you want to delete this product?')) {
            document.getElementById('deleteForm' + id).submit();
        }
    }
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/u559086311/domains/eagleeblaze.com/public_html/hometown/resources/views/admin/products/index.blade.php ENDPATH**/ ?>