

<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h4 class="card-title">Product Details <i class="feather icon-box"></i></h4>
                <a class="heading-elements-toggle"><i class="fa fa-ellipsis-v font-medium-3"></i></a>
                <div class="heading-elements">
                    <ul class="list-inline mb-0">
                        <li><a data-action="collapse"><i class="feather icon-chevron-down"></i></a></li>
                        <li><a data-action="expand"><i class="feather icon-maximize"></i></a></li>
                        <li><a data-action="reload"><i class="feather icon-rotate-cw"></i></a></li>
                        <li><a data-action="close"><i class="feather icon-x"></i></a></li>
                    </ul>
                </div>
            </div>
            <div class="card-content collapse show">
                <div class="card-body">
                    <div class="row mb-2">
                        <div class="col-md-6">
                            <h5>Name:</h5>
                            <p><?php echo e($data->name); ?></p>
                        </div>
                        <div class="col-md-6">
                            <h5>Category:</h5>
                            <p><?php echo e(optional($data->category)->name); ?></p>
                        </div>
                        <div class="col-md-6">
                            <h5>Sub Category:</h5>
                            <p><?php echo e(optional($data->subCategory)->name); ?></p>
                        </div>
                        <div class="col-md-6">
                            <h5>Price:</h5>
                            <p>$<?php echo e($data->price); ?></p>
                        </div>
                        <div class="col-md-6">
                            <h5>Min Price:</h5>
                            <p>$<?php echo e($data->min_price); ?></p>
                        </div>
                        <div class="col-md-6">
                            <h5>Size:</h5>
                            <p><?php echo e($data->size ?? '-'); ?></p>
                        </div>
                        <div class="col-md-6">
                            <h5>Material:</h5>
                            <p><?php echo e($data->material ?? '-'); ?></p>
                        </div>
                        <div class="col-md-6">
                            <h5>Weight:</h5>
                            <p><?php echo e($data->weight ?? '-'); ?></p>
                        </div>
                        <div class="col-md-6">
                            <h5>Colors:</h5>
                            <?php
                                $colors = is_array($data->colors) ? $data->colors : json_decode($data->colors, true);
                            ?>
                            <?php if(!empty($colors)): ?>
                                <ul>
                                    <?php $__currentLoopData = $colors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $color): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li><?php echo e($color); ?></li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            <?php else: ?>
                                <p>-</p>
                            <?php endif; ?>
                        </div>
                        <div class="col-md-6">
                            <h5>Icon:</h5>
                            <?php if($data->icon): ?>
                                <img src="<?php echo e(asset('uploads/products/' . $data->icon)); ?>" alt="icon" style="max-width: 100px;">
                            <?php else: ?>
                                <p>No Icon</p>
                            <?php endif; ?>
                        </div>
                        <div class="col-md-6">
                            <h5>Created At:</h5>
                            <p><?php echo e($data->created_at->format('d/m/Y h:i A')); ?></p>
                        </div>
                    </div>

                    <div class="col-md-6">
                        <a href="<?php echo e(route('admin.products.index')); ?>" class="btn btn-primary mt-2">
                            <i class="ti ti-arrow-left me-1"></i> Back
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/u559086311/domains/eagleeblaze.com/public_html/hometown/resources/views/admin/products/show.blade.php ENDPATH**/ ?>