<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ProductType extends Model
{
    use HasFactory;

    protected $guarded = [];
    
    public function category()
    {
        return $this->belongsTo(Category::class);
    }
    
    public function subCategory()
    {
        return $this->belongsTo(SubCategory::class, 'sub_category_id');
    }
    
    protected $casts = [
        'colors' => 'array', // So Laravel auto-converts to/from JSON
        // 'colors_data' => 'array',
    ];
    
    public function getColorsDataAttribute($value) {
        return json_decode($value);
    }

    public function allProducts()
    {
        return self::all();
    }

    public function storeProduct($data)
    {
        return self::create($data);
    }

    public function findProduct($id)
    {
        return self::findOrFail($id);
    }

    public function whereUpdate($condition, $data)
    {
        return self::where($condition)->update($data);
    }

    public function deleteProduct($id)
    {
        return self::findOrFail($id)->delete();
    }
}
