<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Product extends Model
{
    use HasFactory;

    protected $guarded = [];
    
    public function images()
    {
        return $this->hasMany(ProductImage::class);
    }

    public function athlete() {
        return $this->belongsTo(Ahtlete::class);
    }

    public function category() {
        return $this->belongsTo(Category::class);
    }

    public function productType() {
        return $this->belongsTo(ProductType::class);
    }
    
    public function getColorsAttribute($value){
        return $value ? json_decode($value, true) : [];
    }
}
