<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Concept extends Model
{
    use HasFactory;

    protected $guarded = [];
    
    protected $appends = ['total_profit','total_item_sold','total_products','total_completion'];
   

    public function getTotalProfitAttribute()
    {
        return 0;
    }
    
    public function getTotalItemSoldAttribute()
    {
        return 0;
    }
    
    public function getTotalProductsAttribute()
    {
        return Product::where('category_id',$this->category_id)->where('athlete_id',auth()->user()->id)->count();
    }
    
    public function getTotalCompletionAttribute()
    {
        $total = Product::where('category_id', $this->category_id)
            ->where('athlete_id', auth()->user()->id)
            ->count();
    
        $accepted = Product::where('category_id', $this->category_id)
            ->where('athlete_id', auth()->user()->id)
            ->where('status', 'Accepted')
            ->count();
    
        if ($total === 0) {
            return 0; // agar total 0 hai to percentage bhi 0 hi hoga
        }
    
        $percentage = ($accepted / $total) * 100;
    
        return round($percentage, 2); // 2 decimal tak round
    }
    
    public function athlete() {
        return $this->belongsTo(Ahtlete::class);
    }
    
     public function category() {
        return $this->belongsTo(Category::class,'category_id');
    }
}
