<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class BundleSubscription extends Model
{
    use HasFactory;

    protected $guarded = [];
    protected $table = 'bundle_subscription';
    public function user()
    {
        return $this->belongsTo(Ahtlete::class,'user_id');
    }

    public function package()
    {
        return $this->belongsTo(Bundle::class,'package_id');
    }
    
    public function getContentAttribute($value) {
        return json_decode($value);
    }
}
