<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\ProductController;
use App\Http\Controllers\Api\OrderController;
use App\Http\Controllers\Api\PackageController;
use App\Http\Controllers\Api\Auth\PassportAuthController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::post('create-athlete', 'ApiController@store');
Route::post('signup', 'ApiController@signup');
Route::post('forget-password', 'ApiController@forgetPassword');
Route::post('reset-password', 'ApiController@resetPassword');
Route::post('login', 'ApiController@login');

// Authenticated routes
Route::group(['middleware' => ['jwt.verify']], function() {
	Route::post('background-login', 'ApiController@backgroundLogin');
	Route::post('update-profile', 'ApiController@updateProfile');
	Route::post('change-password', 'ApiController@changePassword');
	Route::post('view-profile', 'ApiController@viewProfile');
// 	Route::post('logout', 'ApiController@logout');
});

Route::get('/all-athletes', [ProductController::class, 'getAllAthletes']);
Route::get('/furious-athletes', [ProductController::class, 'getFuriousAthletes']);
Route::get('/view-athlete/{slug}', [ProductController::class, 'viewAthlete']);
Route::get('/all-athlete-products/{id}', [ProductController::class, 'allAthleteProducts']);
Route::get('/all-products', [ProductController::class, 'getAllProducts']);
Route::get('/product-detail/{id}', [ProductController::class, 'productDetail']);

Route::group(['prefix' => 'auth', 'namespace' => 'Auth'], function () {
	Route::post('register', 'PassportAuthController@register');
	Route::post('login', 'PassportAuthController@login');
	Route::post('admin-login', 'PassportAuthController@adminLogin');
	Route::post('verify-otp', 'PassportAuthController@verify_otp');
	Route::post('resend-code', 'PassportAuthController@resend_code');
	Route::post('forgot-password', 'ForgetPasswordController@sendMail');
	Route::post('verify-code', 'ForgetPasswordController@checkCode');
	Route::post('reset-password', 'ForgetPasswordController@resetPassword');
	
});

Route::post('/order-place', [OrderController::class, 'placeOrder']);

Route::middleware('auth:api')->group(function () {
    Route::post('logout', [PassportAuthController::class, 'logout']);
    Route::get('/categories', [ProductController::class, 'getCategories']);
    Route::get('/get-dashboard', [ProductController::class, 'getDashboard']);
    Route::get('/product-types', [ProductController::class, 'getProductTypes']);
    Route::post('/products', [ProductController::class, 'storeProduct']);
    Route::get('/my-products', [ProductController::class, 'getMyProducts']);
    Route::post('/store-hours', [ProductController::class, 'upsert']);
    Route::post('/update-card', [ProductController::class, 'storeCard']);
    Route::get('/get-store-hours', [ProductController::class, 'getStoreHours']);
    Route::get('/get-card', [ProductController::class, 'getCard']);
    Route::post('/close-account', [ProductController::class, 'closeAccount']);
    Route::post('/store-concept', [ProductController::class, 'storeConcept']);
    Route::get('/check-concept', [ProductController::class, 'checkConcept']);
    Route::post('/update-concept', [ProductController::class, 'updateConcept']);
     Route::post('/store-cashout', [ProductController::class, 'storeCashout']);
    
    Route::get('/get-profile', [ProductController::class, 'profile']);
	Route::post('/update-store', [ProductController::class, 'updateProfile']);
	Route::post('/accept', [ProductController::class, 'accept']);
	Route::post('/age-agreemnet', [ProductController::class, 'agrement']);
	
	Route::get('/packages', [PackageController::class, 'index']);
	Route::get('/bundles', [PackageController::class, 'getBundles']);
    Route::post('/subscriptions', [PackageController::class, 'store']);
    Route::get('/my-subscriptions', [PackageController::class, 'mySubscriptions']);
    
    Route::post('/buy-bundles', [PackageController::class, 'storeBundle']);
    Route::post('/update-bundle', [PackageController::class, 'updateBundle']);
    Route::get('/my-bundles', [PackageController::class, 'myBundles']);
});

Route::prefix('admin')
    ->middleware('auth:user_api')
    ->group(function () {
        Route::apiResource('products', AdminProductController::class);
        Route::apiResource('users', AdminUserController::class);
        Route::post('/store-images/{id}', [\App\Http\Controllers\Api\AdminProductController::class, 'storeImages']);
        Route::get('/get-cashouts', [\App\Http\Controllers\Api\AdminUserController::class, 'getCashout']);
        Route::get('/get-concept', [\App\Http\Controllers\Api\AdminUserController::class, 'getConcept']);
        Route::get('/get-bundle-subscription', [\App\Http\Controllers\Api\AdminUserController::class, 'getBundlesSubscription']);
        Route::get('/view-bundle-subscription/{id}', [\App\Http\Controllers\Api\AdminUserController::class, 'viewBundlesSubscription']);
        Route::post('/update-cashout', [\App\Http\Controllers\Api\AdminUserController::class, 'updateCashout']);
        Route::get('/get-orders', [\App\Http\Controllers\Api\AdminUserController::class, 'getOrders']);
        Route::get('/view-order/{id}', [\App\Http\Controllers\Api\AdminUserController::class, 'viewOrder']);
        Route::post('/update-status/{id}', [\App\Http\Controllers\Api\AdminUserController::class, 'updateStatus']);
        Route::get('/get-athletes', [\App\Http\Controllers\Api\AdminUserController::class, 'getAthletes']);
        Route::get('/view-athlete/{id}', [\App\Http\Controllers\Api\AdminUserController::class, 'viewAthlete']);
        Route::post('/update-status-athlete/{id}', [\App\Http\Controllers\Api\AdminUserController::class, 'updateStatusAthlete']);
        Route::post('/update-furious-athlete/{id}', [\App\Http\Controllers\Api\AdminUserController::class, 'updateFuriousAthlete']);
        
        Route::get('/get-dashboard', [\App\Http\Controllers\Api\AdminUserController::class, 'getDashboard']);
        Route::get('/get-athletes-products', [\App\Http\Controllers\Api\AdminUserController::class, 'getAthletesProducts']);
        Route::get('/view-athlete-product/{id}', [\App\Http\Controllers\Api\AdminUserController::class, 'viewAthleteProduct']);
        Route::post('/update-status-product/{id}', [\App\Http\Controllers\Api\AdminUserController::class, 'updateStatusProduct']);
    });