@extends('admin.layouts.app')

@section('content')
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h4 class="card-title">Product Details <i class="feather icon-box"></i></h4>
                <a class="heading-elements-toggle"><i class="fa fa-ellipsis-v font-medium-3"></i></a>
                <div class="heading-elements">
                    <ul class="list-inline mb-0">
                        <li><a data-action="collapse"><i class="feather icon-chevron-down"></i></a></li>
                        <li><a data-action="expand"><i class="feather icon-maximize"></i></a></li>
                        <li><a data-action="reload"><i class="feather icon-rotate-cw"></i></a></li>
                        <li><a data-action="close"><i class="feather icon-x"></i></a></li>
                    </ul>
                </div>
            </div>
            <div class="card-content collapse show">
                <div class="card-body">
                    <div class="row mb-2">
                        <div class="col-md-6">
                            <h5>Name:</h5>
                            <p>{{ $data->name }}</p>
                        </div>
                        <div class="col-md-6">
                            <h5>Category:</h5>
                            <p>{{ optional($data->category)->name }}</p>
                        </div>
                        <div class="col-md-6">
                            <h5>Sub Category:</h5>
                            <p>{{ optional($data->subCategory)->name }}</p>
                        </div>
                        <div class="col-md-6">
                            <h5>Price:</h5>
                            <p>${{ $data->price }}</p>
                        </div>
                        <div class="col-md-6">
                            <h5>Min Price:</h5>
                            <p>${{ $data->min_price }}</p>
                        </div>
                        <div class="col-md-6">
                            <h5>Size:</h5>
                            <p>{{ $data->size ?? '-' }}</p>
                        </div>
                        <div class="col-md-6">
                            <h5>Material:</h5>
                            <p>{{ $data->material ?? '-' }}</p>
                        </div>
                        <div class="col-md-6">
                            <h5>Weight:</h5>
                            <p>{{ $data->weight ?? '-' }}</p>
                        </div>
                        <div class="col-md-6">
                            <h5>Colors:</h5>
                            @php
                                $colors = is_array($data->colors) ? $data->colors : json_decode($data->colors, true);
                            @endphp
                            @if(!empty($colors))
                                <ul>
                                    @foreach($colors as $color)
                                        <li>{{ $color }}</li>
                                    @endforeach
                                </ul>
                            @else
                                <p>-</p>
                            @endif
                        </div>
                        <div class="col-md-6">
                            <h5>Icon:</h5>
                            @if($data->icon)
                                <img src="{{ asset('uploads/products/' . $data->icon) }}" alt="icon" style="max-width: 100px;">
                            @else
                                <p>No Icon</p>
                            @endif
                        </div>
                        <div class="col-md-6">
                            <h5>Created At:</h5>
                            <p>{{ $data->created_at->format('d/m/Y h:i A') }}</p>
                        </div>
                    </div>

                    <div class="col-md-6">
                        <a href="{{ route('admin.products.index') }}" class="btn btn-primary mt-2">
                            <i class="ti ti-arrow-left me-1"></i> Back
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
