@extends('admin.layouts.app')

@section('content')
<section id="column-selectors">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title">Products</h4>
                    <span>
                        <a href="{{ route('admin.products.create') }}" class="btn btn-primary">
                            <i class="fa fa-plus"></i> Add New
                        </a>
                    </span>
                </div>
                <div class="card-content">
                    <div class="card-body card-dashboard">
                        <div class="table-responsive">
                            <table class="table table-striped" id="datatable">
                                <thead>
                                    <tr>
                                        <th>Name</th>
                                        <th>Category</th>
                                        <th>Min Price</th>
                                        <th>Price</th>
                                        <th>Created At</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($data as $product)
                                        <tr>
                                            <td>{{ $product->name }}</td>
                                            <td>{{ optional($product->category)->name ?? '-' }}</td>
                                            <td>{{ $product->min_price }}</td>
                                            <td>{{ $product->price }}</td>
                                            <td>
                                                <span style="display: none">{{ strtotime($product->created_at) }}</span>
                                                {{ date('d/m/Y H:i:A', strtotime($product->created_at)) }}
                                            </td>
                                            <td>
                                                <div class="d-flex gap-2">
                                                    <a href="{{ route('admin.products.edit', $product->id) }}" class="btn btn-primary btn-sm waves-effect waves-light">
                                                        <i class="feather icon-edit"></i>
                                                    </a>
                                                    <button type="button" class="btn btn-danger btn-sm waves-effect waves-light" onclick="deleteConfirmation({{ $product->id }})">
                                                        <i class="feather icon-trash"></i>
                                                    </button>
                                                    <form action="{{ route('admin.products.destroy', $product->id) }}" method="POST" id="deleteForm{{ $product->id }}">
                                                        @csrf
                                                        @method('DELETE')
                                                    </form>
                                                </div>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
@endsection

@section('footer-js')
<script>
    $('#datatable').DataTable({
        "order": [[5, "desc"]] // created_at column
    });

    function deleteConfirmation(id) {
        if (confirm('Are you sure you want to delete this product?')) {
            document.getElementById('deleteForm' + id).submit();
        }
    }
</script>
@endsection
