<?php

namespace App\Models;

use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Passport\HasApiTokens;

class Ahtlete extends Authenticatable
{
    use HasApiTokens, Notifiable;

    protected $guarded = [];
    
    protected $appends = ['profile_picture_url', 'cover_photo_url','badge_level','has_active_subscription'];
    
    public function card()
    {
        return $this->belongsTo(Card::class,'user_id');
    }
   

    public function getBadgeLevelAttribute()
    {
        $total = $this->badge_amount;
    
        $badges = [
            'Bronze'  => 'https://home-town-hero-liard.vercel.app/bronze.png',
            'Silver'  => 'https://home-town-hero-liard.vercel.app/Silver.png',
            'Gold'    => 'https://home-town-hero-liard.vercel.app/Gold.png',
            'Emerald' => 'https://home-town-hero-liard.vercel.app/Diamond.png',
            'Diamond' => 'https://home-town-hero-liard.vercel.app/Emerlad.png',
            'Royal'   => 'https://home-town-hero-liard.vercel.app/Royal.png',
        ];
    
        if ($total >= 0 && $total <= 250) {
            $percentage = ($total / 250) * 100;
            $percentage = max(10, $percentage);
            return ['name' => 'Bronze', 'image' => $badges['Bronze'], 'percentage' => round($percentage, 2)];
        } elseif ($total >= 251 && $total <= 1000) {
            $percentage = (($total - 251) / (1000 - 251)) * 100;
            $percentage = max(10, $percentage);
            return ['name' => 'Silver', 'image' => $badges['Silver'], 'percentage' => round($percentage, 2)];
        } elseif ($total >= 1001 && $total <= 2500) {
            $percentage = (($total - 1001) / (2500 - 1001)) * 100;
            $percentage = max(10, $percentage);
            return ['name' => 'Gold', 'image' => $badges['Gold'], 'percentage' => round($percentage, 2)];
        } elseif ($total >= 2501 && $total <= 10000) {
            $percentage = (($total - 2501) / (10000 - 2501)) * 100;
            $percentage = max(10, $percentage);
            return ['name' => 'Emerald', 'image' => $badges['Emerald'], 'percentage' => round($percentage, 2)];
        } elseif ($total >= 10001 && $total <= 20000) {
            $percentage = (($total - 10001) / (20000 - 10001)) * 100;
            $percentage = max(10, $percentage);
            return ['name' => 'Diamond', 'image' => $badges['Diamond'], 'percentage' => round($percentage, 2)];
        } elseif ($total >= 20001) {
            return ['name' => 'Royal', 'image' => $badges['Royal'], 'percentage' => 100];
        }
    
        return null;
    }

    
    public function subscriptions()
    {
        return $this->hasMany(Subscription::class,'user_id');
    }

    public function getHasActiveSubscriptionAttribute()
    {
        return $this->subscriptions()
            ->where('package_id', 1)
            ->where('end_date', '>', now())
            ->exists();
    }


    public function getProfilePictureUrlAttribute()
    {
        return $this->profile_picture ? 'https://hometown.eagleeblaze.com/storage/app/' . $this->profile_picture : null;
    }
    
    public function getCoverPhotoUrlAttribute()
    {
        return $this->cover_photo ? 'https://hometown.eagleeblaze.com/storage/app/' . $this->cover_photo : null;
    }
}
