<?php

namespace App\Http\Controllers\Api;

use App\Models\Order;
use App\Models\OrderItem;
use App\Models\Package;
use App\Models\Bundle;
use App\Models\BundleSubscription;
use App\Models\Subscription;
use Illuminate\Support\Facades\DB;
use Stripe\Stripe;
use Illuminate\Http\Request;
use App\Http\Controllers\Api\BaseController;

class PackageController extends BaseController
{
     public function index()
    {
        return response()->json([
            'status' => true,
            'packages' => Package::orderBy('id','desc')->where('is_active', true)->get()
        ]);
    }
    
     public function getBundles()
    {
        return response()->json([
            'status' => true,
            'bundles' => Bundle::get()
        ]);
    }

    public function store(Request $request)
    {
        $request->validate([
            'package_id' => 'required|exists:packages,id',
            'stripe_token' => 'nullable|string',
        ]);
    
        $user = auth()->user();
        $package = Package::findOrFail($request->package_id);
    
        // ✅ Check if user already has an active subscription
        $existing = Subscription::where('user_id', $user->id)
                    ->where('status', 'active')
                    ->whereDate('end_date', '>=', now())
                    ->first();
    
        // if ($existing) {
        //     return $this->respondBadRequest(null, false, 'You already have an active subscription.');
        // }
    
        // If package is paid, token is required
        if ($package->type !== 'free' && !$request->stripe_token) {
            return $this->respondBadRequest(null, false, 'Stripe token is required for paid packages.');
        }
    
        try {
            if ($package->type !== 'free') {
                \Stripe\Stripe::setApiKey('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');
    
                \Stripe\Charge::create([
                    'amount' => $package->price * 100,
                    'currency' => 'usd',
                    'description' => 'Subscription to ' . $package->name,
                    'source' => $request->stripe_token,
                    'metadata' => [
                        'user_id' => $user->id,
                        'package_id' => $package->id,
                    ],
                ]);
            }
    
            $subscription = Subscription::create([
                'user_id' => $user->id,
                'package_id' => $package->id,
                'start_date' => now(),
                'end_date' => now()->addDays($package->duration_in_days),
                'status' => 'active',
            ]);
    
            $message = $package->type === 'free'
                        ? 'Free subscription activated!'
                        : 'Paid subscription created successfully!';
    
            return $this->respond($subscription, [], 201, $message);
    
        } catch (\Exception $e) {
            return response()->json([
                'status' => false,
                'message' => 'Error: ' . $e->getMessage(),
            ], 500);
        }
    }
    
    
    public function storeBundle(Request $request)
    {
        $request->validate([
            'package_id' => 'required',
            'stripe_token' => 'nullable|string',
        ]);
    
        $user = auth()->user();
        $package = Bundle::findOrFail($request->package_id);
    
        // ✅ Check if user already has an active subscription
        // If package is paid, token is required
        if ($package->type !== 'free' && !$request->stripe_token) {
            return $this->respondBadRequest(null, false, 'Stripe token is required for paid packages.');
        }
    
        try {
                \Stripe\Stripe::setApiKey('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');
    
                \Stripe\Charge::create([
                    'amount' => $package->price * 100,
                    'currency' => 'usd',
                    'description' => 'Subscription to ' . $package->title,
                    'source' => $request->stripe_token,
                    'metadata' => [
                        'user_id' => $user->id,
                        'package_id' => $package->id,
                    ],
                ]);
    
             $imagePaths = [];
            if ($request->hasFile('images')) {
                foreach ($request->file('images') as $image) {
                    $path = $image->store('bundle_images', 'public'); // stores in storage/app/public/bundle_images
                    $imagePaths[] = $path;
                }
            }
        
            $subscription = BundleSubscription::create([
                'user_id'    => $user->id,
                'package_id' => $package->id,
                'content'    => json_encode([
                    'text'   => $request->content,
                    'images' => $imagePaths,
                ]),
            ]);
    
            $message = 'Bundle Buy successfully!';
    
            return $this->respond($subscription, [], 201, $message);
    
        } catch (\Exception $e) {
            return response()->json([
                'status' => false,
                'message' => 'Error: ' . $e->getMessage(),
            ], 500);
        }
    }
    
    public function updateBundle(Request $request)
    {
        $subscription = BundleSubscription::where('id',$request->bundle_id)->update([
             'content' => json_encode($request->content),
        ]);

        $message = 'Bundle Updated successfully!';

        return $this->respond($subscription, [], 201, $message);
    }



    public function mySubscriptions()
    {
        $subscriptions = Subscription::with('package')
            ->where('user_id', auth()->id())
            ->latest()
            ->get();
            
             return $this->respond($subscriptions, [], 201, 'Success');
    }
    
    public function myBundles()
    {
        $subscriptions = BundleSubscription::with('package')
            ->where('user_id', auth()->id())
            ->latest()
            ->get();
            
             return $this->respond($subscriptions, [], 201, 'Success');
    }
}

