<?php

namespace App\Http\Controllers\Api;

use App\Models\Order;
use App\Models\OrderItem;
use Illuminate\Support\Facades\DB;
use Stripe\Stripe;
use Stripe\Charge;
use Illuminate\Http\Request;
use App\Http\Controllers\Api\BaseController;

class OrderController extends BaseController
{
    public function placeOrder(Request $request)
    {
        $request->validate([
            'full_name' => 'required',
            'email' => 'required|email',
            'address' => 'required',
            'city' => 'required',
            'postal_code' => 'required',
            'country' => 'required',
            'stripe_token' => 'required|string',
            'items' => 'required|array|min:1',
            'items.*.product_id' => 'required|exists:products,id',
            'items.*.price' => 'required|numeric',
            'items.*.quantity' => 'required|integer|min:1',
        ]);
    
        $totalAmount = collect($request->items)->sum(fn($item) => $item['price'] * $item['quantity']);
        
        // Add shipping and tax if provided
        $shipping = $request->shipping ?? 0;
        $tax = $request->tax ?? 0;
        
        $totalAmount = $totalAmount + $shipping + $tax;
        $amountInCents = $totalAmount * 100; // Stripe uses cents
    
        DB::beginTransaction();
    
        try {
            // Initialize Stripe
            Stripe::setApiKey('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');
    
            // Create Stripe Charge
            $charge = Charge::create([
                'amount' => $amountInCents,
                'currency' => 'usd',
                'description' => 'Order Payment from ' . $request->email,
                'source' => $request->stripe_token,
                'receipt_email' => $request->email,
            ]);
    
            if ($charge->status !== 'succeeded') {
                return response()->json([
                    'status' => false,
                    'message' => 'Payment failed. Please try again.',
                ], 400);
            }
    
            // Store Order
            $order = Order::create([
                'full_name' => $request->full_name,
                'email' => $request->email,
                'address' => $request->address,
                'city' => $request->city,
                'postal_code' => $request->postal_code,
                'country' => $request->country,
                'total_price' => $totalAmount,
                'shipping' => $shipping,
                'tax' => $tax,
            ]);
    
            // Store Order Items
            foreach ($request->items as $item) {
                OrderItem::create([
                    'order_id' => $order->id,
                    'product_id' => $item['product_id'],
                    'price' => $item['price'],
                    'quantity' => $item['quantity'],
                    'color' => json_encode($item['color']),
                ]);
            }
    
            DB::commit();
    
            return $this->respond($order, [], 201, 'Order placed & payment successful');
    
        } catch (\Exception $e) {
            DB::rollBack();
    
            return response()->json([
                'status' => false,
                'message' => 'Something went wrong!',
                'error' => $e->getMessage(),
            ], 500);
        }
    }
}

